#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cassert>
#include <ctime>

#include <iostream>
#include <iomanip>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <deque>
#include <queue>
#include <stack>
#include <algorithm>


#define forn(i, n) for(int i = 0; i < int(n); i++)
#define mp make_pair
#define pb push_back
#define foreach(it, v) for(__typeof(v.begin()) it = v.begin(); it != v.end(); ++it)

using namespace std;

typedef long long ll;

const int kMaxN = 1000;

ll S;
int n;
ll values[kMaxN];
ll history[kMaxN];
bool can[kMaxN];

ll divUp(ll a, ll b) {
	if(a <= 0) return 0;
	return (a + b - 1) / b;
}

ll solveSmart() {
	sort(values, values + n);
	int m = n - 1;
	while(values[m] > S)
		--m;
	++m;
	ll result = 0, current = 0;
	for(int i = 0; i < m; i++) {
		assert(current + 1 >= values[i]);
		if(i + 1 < m) {
			ll k = divUp(values[i + 1] - 1 - current, values[i]);
			current += values[i] * k;
			result += k;
		} else {
			ll k = divUp(S - current, values[i]);
			result += k;
		}
	}
	return result;
}

 bool good() {
	memset(can, 0, sizeof(can));
	can[0] = true;
	for(int i = 0; i < n; i++) {
		int value = values[i];
		for(int j = 0; j < history[i]; j++) {
			for(int w = S; w >= 0; w--) {
				if(can[w]) can[w + value] = true;
			}
		}
	}
	for(int i = 1; i <= S; i++) if(!can[i]) return false;
	return true;
 }

ll rec(int step, ll taken) {
	if(step == n) {
		return good() ? taken : S;
	} else {
		ll result = S;
		for(int take = 0; take * values[step] <= S; take++) {
			history[step] = take;
			result = min(result, rec(step + 1, taken + take));
		}
		return result;
	}
}

ll solveDumb() {
	return rec(0, 0);
}

int main() {
	//srand(time(NULL));
	scanf("%d", &n);
	//n = 8;
	for(int i = 0; i < n; i++) {
		values[i] = (rand() % 10) + 1;
		scanf("%lld", &values[i]);
	}
	//values[0] = 1;
	//S = (rand() % 20) + 1;
	scanf("%lld", &S);
	ll smartResult = solveSmart();
	//ll dumbResult = solveDumb();
	//if(smartResult != dumbResult) {
	//	printf("FAIL %lld %lld\n", smartResult, dumbResult);
	//	for(int i = 0; i < n; i++)
	//		printf("%lld\n", values[i]);
	//	printf("%lld\n", S);
	//}
	printf("%lld\n", smartResult);
	return 0;
}